 ; Ŀ
 ;   Plat - put plot data on a drawing.                                    
 ;   Copyright 1995, 1999, 2001, 2004, 2005 by Rocket Software Ltd.        
 ;   There is no flying creature which can remain aloft indefinitely.      
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen oldlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Dast - make the drawing data string.                       
 ;   Brooks no arguments.                                                  
 ; 
 (DEFUN DAST (/ dd yy date hourp min hour ampm name pref unam)
 ; Ŀ
 ;   Make the date string.                                                 
 ; 
  (setq dd (rtos (getvar "cdate") 2 0))
  (setq yy (substr dd 1 4) mm (substr dd 5 2) da (substr dd 7 2))
  (setq dd (strcat yy "." mm "." da))
  (setq date (rtos (getvar "cdate") 2 12))
  (setq hourp (read (substr date 10 2)))
  (setq min (substr date 12 2))
  (if (> hourp 12)
      (setq hour (itoa (- hourp 12)))
      (setq hour (itoa hourp)))
  (if (and (>= hourp 12)
           (> (read min) 0))
      (setq ampm "pm")
      (setq ampm "am"))
  (setq dd (strcat  dd " " hour ":" min ampm))
 ; The following line can do most of that.  Maybe more.
 ; (menucmd "M=$(edtime,$(getvar,date),DDDD MONTH D\",\" YYYY h:mmam/pm)")
 ; Ŀ
 ;   Make the drawing name and path string.                                
 ; 
  (setq name (getvar "dwgname"))
  (setq pref (getvar "dwgprefix"))
  (setq name (strcat pref name))
 ; Ŀ
 ;   Remove the extension.                                                 
 ; 
  (if (= (substr (strcase name t) (- (setq len (strlen name)) 3)) ".dwg")
      (setq name (substr name 1 (- len 4))))
 ; Ŀ
 ;   If the current text style is based on the Rocket.shx font then        
 ;   modify the backslashes.                                               
 ; 
  (if (= "ROCKET.SHX" (strcase (cdr (assoc 3 (tblsearch "style" "standard")))))
      (setq name (car (chug "\\" "%%002" name))))
 ; Ŀ
 ;   Make something like the user initials.                                
 ;   Check the list for pseudo-initials for those who don't follow the     
 ;   pattern, if none are found then use the default.                      
 ;   Consider reading the user name from a data file, maybe use Gnash      
 ;   if a flag is set.                                                     
 ; 
  (setq usrlst '(("MIGGLESDEN" "MIG")
                 ("JTAYLOR" "JET")
                 ("WBOYDE" "The Coach")
                 ("CARNAHAN" "Ryan")
                 ("BATESTR" "The Amazing Trent")
                 ("GEMINI" "SW")))
  (setq unam (strcase (getvar "loginname")))
  (if (setq unamp (assoc unam usrlst))
      (setq unam (cadr unamp))
      (setq unam (substr unam 1 2)))
 ; Ŀ
 ;   And concoct a final data string.                                      
 ; 
 (strcat name "  " dd "  Plotted by " unam))
 ; Ŀ
 ;   Dast end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Hnf - make a text style be not fixed height.               
 ;   Arguments: Stanam, the style name in question.                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN HNF (stanam / tt tabl foon hite widt oblq verti sevt1 back upsd)
  (setvar "cmdecho" 0)
  (setq tt (getvar "textstyle"))
  (setq tabl (tblsearch "style" tt))
  (setq foon (cdr (assoc 3 tabl)))
  (setq hite (cdr (assoc 40 tabl)))    ; but force to zero
  (setq widt (cdr (assoc 41 tabl)))
  (setq oblq (cdr (assoc 50 tabl)))
  (setq sevt1 (cdr (assoc 71 tabl)))
  (setq back (if (= 2 (logand sevt1 2)) "Y" "N"))
  (setq upsd (if (= 4 (logand sevt1 4)) "Y" "N"))
  (setq verti (if (= 4 (logand (cdr (assoc 70 tabl)) 4)) "Y" "N"))
  (command ".style"
           stanam            ; name of text style
           foon              ; full font name or font filename (TTF or SHX)
           0                 ; height of text
           widt              ; width factor
           oblq              ; obliquing angle
           back              ; display text backwards? [Yes/No]
           upsd)             ; display text upside-down? [Yes/No]
  (if (= 1 (getvar "cmdactive"))
      (command verti))       ; vertical? (only asked if can be vertical)
 (princ))
 ; Ŀ
 ;   Subroutine Hnf end.                                                   
 ; 

 ; Ŀ
 ;   Subroutine Nuze: Inserts a plot data text string...maybe.             
 ;   Calls nothing, returns nothing, is beset by nihilism.                 
 ; 
 (DEFUN NUZE (dart / curstyl styles stop num styc ss bent bnam scal pa rota
                        txtabl stnam po lave entt emax emin ovrht txht txofs)
 ; Ŀ
 ;   Try to set the current text style to something not too baroque.       
 ; 
  (setq curstl (getvar "textstyle"))
  (setq styles (list "standard" "romans" "simplex"))
  (setq num 0)
  (while (and (null stop) (setq styc (nth num styles)))
         (setq num (1+ num))
         (if (tblsearch "style" styc)
             (progn
                  (setvar "textstyle" styc)
                  (setq stop t))))
 ; Ŀ
 ;   If the current text style is fixed height make it not.                
 ; 
         (setq txtabl (tblsearch "style" (setq stnam (getvar "textstyle"))))
         (if (/= 0 (setq fh (cdr (assoc 40 txtabl))))
             (hnf stnam))
 ; Ŀ
 ;   Insert the plot data text.                                            
 ;   Redo this based on Insta.lsp.                                         
 ;   First look for Encana TBs.                                            
 ; 
  (cond ((or (setq ss (ssget "X" (list (cons 2 "t-a002a"))))
             (setq ss (ssget "X" (list (cons 2 "t2a-3")))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq rotinc (/ (* pi 36.86989765) 180))
         (setq po (polar pa (+ rota rotinc) (* scal 20)))
         (setq rota (* (/ rota pi) 180))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (command "text" "ml" po (* 4 scal) (+ rota 90) dart)
         (setvar "clayer" lave))
 ; Ŀ
 ;   Gemini.                                                               
 ; 
        ((setq ss (ssget "X" (list (cons 2 "gca1tb"))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq rotinc (/ (* pi 168.69) 180))
         (setq po (polar pa (+ rota rotinc) (* scal 12.75)))
         (setq rota (* (/ rota pi) 180))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (command "text" "ml" po (* 4 scal) (+ rota 90) dart)
         (setvar "clayer" lave))
 ; Ŀ
 ;   There was no known TB.                                                
 ; 
        (T
         (setq emax (getvar "extmax"))
         (setq emin (getvar "extmin"))
         (setq ovrht (- (cadr emax) (cadr emin)))
         (setq txht (/ ovrht 190.0))
         (setq txofs (/ ovrht 40.0))
         (setq pa (polar emin (/ pi 2) txofs))
         (setq pa (polar pa pi (* txht 2)))
         (setq lave (getvar "clayer"))
         (setvar "clayer" "0")
         (command "text" "ml" pa txht 90 dart)
         (setvar "clayer" lave)))
 ; Ŀ
 ;   Put the text style back the way it was.                               
 ; 
  (setvar "textstyle" curstl)
 (princ))
 ; Ŀ
 ;   Nuze end.                                                             
 ; 

 ; Ŀ
 ;   Plat.                                                                 
 ; 
 (DEFUN C:PLAT (/ enama)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Make and insert a text string.                                        
 ; 
  (nuze (dast))
  (if (and (setq enam (entlast))
           (= "TEXT" (cdr (assoc 0 (entget enam)))))
      (setq enama enam))
 ; Ŀ
 ;   Plot the drawing (otherwise there is little point to this.)           
 ; 
  (c:np)
 ; Ŀ
 ;   Delete the text string.                                               
 ; 
  (entdel enama)
 (princ))